﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Win32;
using Winfoot_7_SDK;

namespace WinfootDefaultSystemPlugin.Controls.Strategy
{
    public interface IClearRecentDocsOnExitStrategy
    {
        void Write(int i);
        WFRegistry Read();
        List<WFRegistry> BackUp();
    }

    public class ClearRecentDocsOnExitDefaultStrategy : ICorrespondenceOS, IClearRecentDocsOnExitStrategy
    {
        public ClearRecentDocsOnExitDefaultStrategy()
        {
            CorrespondenceOSList = new List<OS>
                                       {
                                           OS.WindowsXP,
                                           OS.WindoesXP_SP1,
                                           OS.WindowsXP_SP2,
                                           OS.WindowsXP_SP3,

#if DEBUG
                                           OS.WindowsVista,
                                           OS.WindowsVista_SP1,
                                           OS.WindowsVista_SP2,
                                           OS.WindowsSeven
#endif
                                       };
        }

        private string RegName = "ClearRecentDocsOnExit";

        #region ICorrespondenceOS メンバ

        public List<OS> CorrespondenceOSList { get; set; }

        #endregion

        public void Write(int i)
        {
            RegistryKey registryKey =
                Registry.LocalMachine.CreateSubKey(
                    @"Software\Microsoft\Windows\CurrentVersion\Policies\Explorer");

            registryKey.SetValue(RegName, i);
        }

        public WFRegistry Read()
        {
            RegistryKey registryKey =
                Registry.LocalMachine.OpenSubKey(
                    @"Software\Microsoft\Windows\CurrentVersion\Policies\Explorer");

            return new WFRegistry(@"HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Policies\Explorer", RegName,
                              registryKey.GetValue(RegName, 0), RegistryValueKind.DWord, RegOperation.KeyWrite);



        }

        public List<WFRegistry> BackUp()
        {
            return new List<WFRegistry> { Read() };
        }

    }

    public class ClearRecentDocsOnExitController
    {
        public ClearRecentDocsOnExitController(ClearRecentDocsOnExit clearRecentDocsOnExit,
                                                         IClearRecentDocsOnExitStrategy strategy)
        {
            ClearRecentDocsOnExit = clearRecentDocsOnExit;
            Strategy = strategy;
        }

        public ClearRecentDocsOnExit ClearRecentDocsOnExit { get; set; }
        public IClearRecentDocsOnExitStrategy Strategy { get; set; }

        public void Read()
        {
            ClearRecentDocsOnExit.SetClearRecentDocsOnExitState(Convert.ToBoolean(Strategy.Read().Value));
        }

        public void Write()
        {
            Strategy.Write(ClearRecentDocsOnExit.GetClearRecentDocsOnExitState());
        }

        public List<WFRegistry> BackUp()
        {
            return Strategy.BackUp();
        }
    }
}
